package ru.yandex.chemodan.app.webdav.repository.properties;

import java.util.function.Supplier;

import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.webdav.auth.AuthInfo;
import ru.yandex.chemodan.mpfs.MpfsFileInfo;

/**
 * @author tolmalev
 */
public interface PropertiesFactory {
    int order();
    boolean accepts(DavPropertyName name);
    ListF<DavProperty> cons(Supplier<MpfsFileInfo> info, AuthInfo auth, DavPropertyName name);

    default ListF<String> getMetaFields(DavPropertyName name) {
        return Cf.list();
    }
}
