package ru.yandex.chemodan.app.webdav.repository.properties;

import java.io.ByteArrayInputStream;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ru.yandex.misc.lang.StringUtils;
import ru.yandex.misc.xml.dom.DomUtils;

/**
 * @author tolmalev
 */
public class XmlPropertyUtils {
    static Object hackYadropXml(String str) {
        try {
            if (str.startsWith("?")) {
                Object result = hackYadropXml(str.substring(1));
                if (result instanceof String) {
                    return "?" + result;
                } else {
                    return result;
                }
            }

            if (str.startsWith("<>") && str.endsWith("</>")) {
                str = StringUtils.removeStart(str, "<>");
                str = StringUtils.removeEnd(str, "</>");

                str = "<a>" + str + "</a>";

                Document doc = DomUtils.read(new ByteArrayInputStream(str.getBytes()));
                if (doc.getChildNodes().getLength() >= 1) {
                    NodeList nodes = doc.getChildNodes().item(0).getChildNodes();
                    Node[] res = new Node[nodes.getLength()];
                    for (int i = 0; i < nodes.getLength(); i++) {
                        res[i] = nodes.item(i);
                    }

                    return res;
                } else {
                    return new Node[]{};
                }
            }

            return DomUtils.read(new ByteArrayInputStream(str.getBytes())).getDocumentElement();
        } catch (RuntimeException e) {
            return str;
        }
    }
}
