package ru.yandex.chemodan.app.webdav.repository.upload;

import java.util.List;
import java.util.Optional;
import java.util.function.UnaryOperator;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.chemodan.boot.value.OverridableValuePrefix;
import ru.yandex.chemodan.util.http.HttpClientConfigurator;
import ru.yandex.misc.io.http.apache.v4.ApacheHttpClientUtils;

/**
 * @author tolmalev
 */
@Configuration
public class DavUploaderContextConfiguration {
    @Bean
    public UploaderClient uploaderClient(
            @Qualifier("uploaderClient") Optional<List<UnaryOperator<ApacheHttpClientUtils.Builder>>> interceptors)
    {
        ApacheHttpClientUtils.Builder builder = uploaderHttpClientConfigurator().createBuilder();

        return new UploaderClient(interceptors.orElseGet(Cf::list).stream().reduce((a, b) -> a.andThen(b)::apply).orElse(UnaryOperator.identity()).apply(builder).build());
    }

    @Bean
    @OverridableValuePrefix("uploader")
    public HttpClientConfigurator uploaderHttpClientConfigurator() {
        return new HttpClientConfigurator();
    }
}
