package ru.yandex.chemodan.app.webdav.repository.upload;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.uploader.util.http.HttpContentRange;
import ru.yandex.misc.ip.IpAddress;

/**
 * @author tolmalev
 */
public class Upload {
    public Mode mode = Mode.NORMAL;

    public Option<Long> contentLength;
    public Option<String> yandexDiff = Option.empty();
    public Option<String> replaceMd5 = Option.empty();
    public Option<String> md5 = Option.empty();
    public Option<String> sha256 = Option.empty();
    public Option<Long> size = Option.empty();

    public Option<String> livePhotoMd5 = Option.empty();
    public Option<String> livePhotoSha256 = Option.empty();
    public Option<String> livePhotoType = Option.empty();
    public Option<Long> livePhotoSize = Option.empty();
    public Option<String> livePhotoOperation = Option.empty();

    public Option<String> photostreamDestination = Option.empty();

    public Option<String> deviceResourceSubtype = Option.empty();
    public Option<String> deviceCollections = Option.empty();
    public Option<String> deviceOriginalPath = Option.empty();

    public Option<Instant> ctime = Option.empty();
    public Option<Instant> mtime = Option.empty();
    public Option<Instant> etime = Option.empty();

    public Option<String> type = Option.empty();

    public Option<HttpContentRange> contentRange = Option.empty();
    public Option<String> contentEncoding = Option.empty();
    public Option<String> contentType = Option.empty();

    public Option<String> sourceId = Option.empty();
    public Option<String> forceDeletionLogDeduplication = Option.empty();

    public IpAddress remoteIpAdress;

    public boolean force;
    public boolean hidden;
    public boolean isScreenshot;
    public boolean isPublic;

    public enum Mode {
        NORMAL,
        DELTA,
        RESUME
    }
}
