package ru.yandex.chemodan.app.webdav.repository.upload;

import org.junit.Test;

import ru.yandex.misc.test.Assert;

/**
 * @author tolmalev
 */
public class UploadUtilsTest {
    @Test
    public void parseDate() throws Exception {
        String dateStr = "Tue, 07 Feb 2017 16:08:47 GMT+00:00";

        Assert.some(UploadUtils.parseDate(dateStr));
        Assert.some(UploadUtils.parseDate("\"" + dateStr + "\""));
        Assert.some(UploadUtils.parseDate("   \"  " + dateStr + "  \"   "));
    }

    @Test
    public void parseEmptyDisposition() throws Exception {
        Upload upload = new Upload();
        UploadUtils.parseDisposition("", upload);

        Assert.none(upload.type);
        Assert.none(upload.ctime);
        Assert.none(upload.mtime);
        Assert.isFalse(upload.isScreenshot);
        Assert.isFalse(upload.isPublic);
    }

    @Test
    public void parseScreenshotDisposition() throws Exception {
        Upload upload = new Upload();
        UploadUtils.parseDisposition("screenshot", upload);

        Assert.some("screenshot", upload.type);
        Assert.none(upload.ctime);
        Assert.none(upload.mtime);
        Assert.isTrue(upload.isScreenshot);
        Assert.isFalse(upload.isPublic);
    }

    @Test
    public void parsePublicScreenshotDisposition() throws Exception {
        Upload upload = new Upload();
        UploadUtils.parseDisposition("screenshot; public=true", upload);

        Assert.some("screenshot", upload.type);
        Assert.none(upload.ctime);
        Assert.none(upload.mtime);
        Assert.isTrue(upload.isScreenshot);
        Assert.isTrue(upload.isPublic);
    }

    @Test
    public void parsePublicScreenshotWithCtimeDisposition() throws Exception {
        Upload upload = new Upload();
        UploadUtils.parseDisposition("screenshot; public=true; creation-date=Tue, 07 Feb 2017 16:08:47 GMT+00:00", upload);

        Assert.some("screenshot", upload.type);
        Assert.some(upload.ctime);
        Assert.none(upload.mtime);
        Assert.isTrue(upload.isScreenshot);
        Assert.isTrue(upload.isPublic);
    }

    @Test
    public void parsePublicScreenshotWithMtimeDisposition() throws Exception {
        Upload upload = new Upload();
        UploadUtils.parseDisposition("screenshot; public=true; modification-date=Tue, 07 Feb 2017 16:08:47 GMT+00:00", upload);

        Assert.some("screenshot", upload.type);
        Assert.none(upload.ctime);
        Assert.some(upload.mtime);
        Assert.isTrue(upload.isScreenshot);
        Assert.isTrue(upload.isPublic);
    }

    @Test
    public void parseCtimeMtimeDisposition() throws Exception {
        Upload upload = new Upload();
        UploadUtils.parseDisposition("strangeType; creation-date=Tue, 07 Feb 2017 16:08:47 GMT+00:00 ;modification-date=Tue, 07 Feb 2017 16:08:47 GMT+00:00", upload);

        Assert.some("strangeType", upload.type);
        Assert.some(upload.ctime);
        Assert.some(upload.mtime);
        Assert.isFalse(upload.isScreenshot);
        Assert.isFalse(upload.isPublic);
    }
}
