package ru.yandex.chemodan.app.webdav.servlet;

import java.io.IOException;

import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.WebdavRequest;
import org.apache.jackrabbit.webdav.WebdavResponse;

import ru.yandex.chemodan.app.webdav.repository.MpfsInviteResource;
import ru.yandex.chemodan.app.webdav.repository.MpfsResource;
import ru.yandex.chemodan.mpfs.MpfsClient;
import ru.yandex.misc.io.http.HttpStatus;
import ru.yandex.misc.io.http.UrlUtils;
import ru.yandex.misc.lang.StringUtils;

/**
 * @author tolmalev
 */
public class AcceptInviteHandler implements DavMethodHandler {
    private final MpfsClient mpfsClient;
    private final String publicHostPrefix;

    public AcceptInviteHandler(MpfsClient mpfsClient, String publicHostPrefix) {
        this.mpfsClient = mpfsClient;
        this.publicHostPrefix = publicHostPrefix + (publicHostPrefix.endsWith("/") ? "" : "/");
    }

    @Override
    public void handle(WebdavRequest request, WebdavResponse response, MpfsResource resource)
            throws IOException, DavException
    {
        MpfsInviteResource invite = (MpfsInviteResource) resource;
        String path = mpfsClient.acceptInvite(invite.getUser(), invite.getInvite().hash);
        path = UrlUtils.urlEncode(StringUtils.removeStart(path, "/")).replace("+", "%20");

        response.setStatus(HttpStatus.SC_301_MOVED_PERMANENTLY);
        response.addHeader("Location", publicHostPrefix + path);
    }

    @Override
    public String method() {
        return "POST";
    }

    @Override
    public boolean matches(WebdavRequest request, MpfsResource resource) {
        return resource instanceof MpfsInviteResource;
    }

    @Override
    public int order() {
        return 1;
    }
}
