package ru.yandex.chemodan.app.webdav.servlet;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;

import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.WebdavRequest;
import org.apache.jackrabbit.webdav.WebdavResponse;

import ru.yandex.chemodan.app.webdav.auth.AuthInfo;
import ru.yandex.chemodan.app.webdav.filter.AuthenticationFilter;
import ru.yandex.chemodan.app.webdav.repository.MpfsResource;

/**
 * @author tolmalev
 */
public interface DavMethodHandler {
    void handle(WebdavRequest request, WebdavResponse response, MpfsResource resource) throws IOException, DavException;
    String method();

    default boolean matches(WebdavRequest request, MpfsResource resource) {
        return true;
    }

    default int order() {
        return 0;
    }

    default AuthInfo getAuthInfo(HttpServletRequest request) {
        return AuthenticationFilter.getAuthInfo(request);
    }
}
