package ru.yandex.chemodan.app.webdav.servlet;

import java.io.IOException;

import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.WebdavRequest;
import org.apache.jackrabbit.webdav.WebdavResponse;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.webdav.auth.AuthInfo;
import ru.yandex.chemodan.app.webdav.repository.ComplexCallback;
import ru.yandex.chemodan.app.webdav.repository.MpfsResource;
import ru.yandex.chemodan.app.webdav.repository.MpfsResourceManager;
import ru.yandex.chemodan.app.webdav.repository.PathUtils;
import ru.yandex.chemodan.util.http.RequestUtils;
import ru.yandex.misc.io.http.HttpStatus;

/**
 * @author tolmalev
 */
public class DeleteHandler extends DavHandlerBase {
    protected DeleteHandler(MpfsResourceManager manager) {
        super(manager, "DELETE");
    }

    @Override
    public void handle(WebdavRequest request, WebdavResponse response, MpfsResource resource)
            throws IOException, DavException
    {
        Option<String> ifMatch = RequestUtils.getIfMatch(request);

        SourcePaths sourcePaths = extractSourcePaths(request, resource);

        AuthInfo authInfo = getAuthInfo(request);

        int okStatusCode = authInfo.clientCapabilities.isDelete200()
                           ? HttpStatus.SC_200_OK
                           : HttpStatus.SC_204_NO_CONTENT;

        ListF<ComplexCallback.AsyncOperation> operations = sourcePaths.getPaths()
                .map(srcPath -> new ComplexCallback.AsyncOperation(
                        PathUtils.href(srcPath, authInfo),
                        okStatusCode,
                        (ctx, operationId, callback) ->
                {
                    if (isTrashAppend(authInfo, request)) {
                        return manager.asyncTrashAppend(resource.getUser(), srcPath,
                                ifMatch,
                                authInfo.isOurClient(),
                                callback
                        );
                    } else {
                        return manager.asyncRm(resource.getUser(), srcPath,
                                ifMatch,
                                authInfo.isOurClient(),
                                callback
                        );
                    }
                }
        ));

        applySingleOrComplex(request, operations, sourcePaths.isMultiple());
    }

    private boolean isTrashAppend(AuthInfo authInfo, WebdavRequest request) {
        return !Option.ofNullable(request.getParameter("trash")).isSome("false") && authInfo.isOurClient();
    }
}
