package ru.yandex.chemodan.app.webdav.servlet;

import java.io.IOException;

import org.apache.http.client.HttpClient;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.WebdavRequest;
import org.apache.jackrabbit.webdav.WebdavResponse;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.webdav.repository.MpfsResource;
import ru.yandex.chemodan.mpfs.MpfsFileInfo;
import ru.yandex.inside.mulca.MulcaClient;
import ru.yandex.inside.mulca.MulcaId;
import ru.yandex.misc.dataSize.DataSize;
import ru.yandex.misc.io.http.HttpStatus;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.web.servlet.HttpServletRequestX;

/**
 * @author tolmalev
 */
public class GetDigestHandler extends GetHandler {
    private static final Logger logger = LoggerFactory.getLogger(GetDigestHandler.class);

    public GetDigestHandler(DataSize redirectGetThreshold,
            MulcaClient mulcaClient,
            HttpClient httpClient)
    {
        super(redirectGetThreshold, mulcaClient, httpClient);
    }

    @Override
    public void handle(WebdavRequest request, WebdavResponse response, MpfsResource resource)
            throws IOException, DavException
    {
        if (resource.isCollection()) {
            throw new DavException(HttpStatus.SC_415_UNSUPPORTED_MEDIA_TYPE);
        }
        MpfsFileInfo info = resource.getFileInfo();

        info.getMeta().getMd5().forEach(v -> response.addHeader("ETag", v));
        info.getMeta().getMimeType().forEach(v -> response.addHeader("Content-Type", v));

        Option<String> rangeHeader = HttpServletRequestX.wrap(request).getHeaderO("Range");

        spoolFileContent(info,
                MulcaId.fromSerializedString(info.getMeta().getDigestMid().get()), request, response, rangeHeader);
    }
    @Override
    public String method() {
        return "GET";
    }

    @Override
    public int order() {
        return 1;
    }

    @Override
    public boolean matches(WebdavRequest request, MpfsResource resource) {
        String qs = request.getQueryString();
        return qs != null && qs.startsWith("digest");
    }
}
