package ru.yandex.chemodan.app.webdav.servlet;

import java.io.IOException;

import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.WebdavRequest;
import org.apache.jackrabbit.webdav.WebdavResponse;

import ru.yandex.chemodan.app.webdav.repository.MpfsResource;
import ru.yandex.chemodan.mpfs.MpfsFileInfo;
import ru.yandex.misc.io.http.HttpStatus;

/**
 * @author tolmalev
 */
public class HeadHandler implements DavMethodHandler {

    @Override
    public String method() {
        return "HEAD";
    }

    @Override
    public void handle(WebdavRequest request, WebdavResponse response, MpfsResource resource)
            throws IOException, DavException
    {
        if (!resource.exists()) {
            throw new DavException(HttpStatus.SC_404_NOT_FOUND);
        }

//        long modSince = request.getDateHeader("If-Modified-Since");
//        if (modSince > DavConstants.UNDEFINED_TIME) {
//            long modTime = resource.getModificationTime();
//            // test if resource has been modified. note that formatted modification
//            // time lost the milli-second precision
//            if (modTime != DavConstants.UNDEFINED_TIME && (modTime / 1000 * 1000) <= modSince) {
//                // resource has not been modified since the time indicated in the
//                // 'If-Modified-Since' header.
//                response.setStatus(HttpServletResponse.SC_NOT_MODIFIED);
//                return;
//            }
//        }

        // spool resource properties and eventually resource content.

        MpfsFileInfo info = resource.getFileInfo();

        //TODO: do smth with if-match
        if (!resource.isCollection()) {
            response.addHeader("Accept-Ranges", "bytes");
            info.getMeta().getMimeType().forEach(response::setContentType);
            info.getMeta().getMd5().forEach(v -> response.addHeader("ETag", v));
        }
        info.getMeta().getSize().forEach(size -> response.addHeader("Content-Length", String.valueOf(size.toBytes())));
        response.addDateHeader(DavConstants.HEADER_LAST_MODIFIED, info.times.mtime * 1000);
    }
}
