package ru.yandex.chemodan.app.webdav.servlet;

import java.io.IOException;

import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.WebdavRequest;
import org.apache.jackrabbit.webdav.WebdavResponse;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.webdav.auth.AuthInfo;
import ru.yandex.chemodan.app.webdav.filter.AuthenticationFilter;
import ru.yandex.chemodan.app.webdav.repository.MpfsResource;
import ru.yandex.chemodan.mpfs.MpfsClient;
import ru.yandex.misc.io.http.HttpStatus;

/**
 * @author yashunsky
 */
public class InstallHandler implements DavMethodHandler {
    private final MpfsClient mpfsClient;

    public InstallHandler(MpfsClient mpfsClient) {
        this.mpfsClient = mpfsClient;
    }

    @Override
    public void handle(WebdavRequest request, WebdavResponse response, MpfsResource resource) throws IOException,
            DavException
    {
        AuthInfo info = AuthenticationFilter.getAuthInfo(request);

        Option<String> platform = request.getParameter("desktop") != null ? Option.of("desktop") :
                request.getParameter("mobile") != null ? Option.of("mobile") : Option.empty();

        if (info.uid.isPresent() && platform.isPresent()) {
            response.setStatus(
                    mpfsClient.stateSet(info, platform.get() + "_installed", "1").getStatusCode());
        } else {
            response.sendError(HttpStatus.SC_404_NOT_FOUND);
        }
    }

    @Override
    public String method() {
        return "GET";
    }

    @Override
    public boolean matches(WebdavRequest request, MpfsResource resource) {
        return request.getParameter("install") != null;
    }

    @Override
    public int order() {
        return 1;
    }
}
