package ru.yandex.chemodan.app.webdav.servlet;

import javax.xml.XMLConstants;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author tolmalev
 */
public class JackrabbitHacks {
    private static final Logger logger = LoggerFactory.getLogger(JackrabbitHacks.class);

    private JackrabbitHacks() { }

    /**
     * Prevent XXE and related attacks in CalDAV (CAL-5902)
     *
     * @url https://www.owasp.org/index.php/XML_External_Entity_%28XXE%29_Processing
     * @url http://en.wikipedia.org/wiki/Billion_laughs
     */
    public static void configureXmlParserForSecurity() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setIgnoringComments(true);
            factory.setIgnoringElementContentWhitespace(true);
            factory.setCoalescing(true);
            try {
                factory.setFeature(XMLConstants.FEATURE_SECURE_PROCESSING, true);
            } catch (ParserConfigurationException | AbstractMethodError e) {
                logger.warn("Secure XML processing is not supported", e);
            }

            factory.setFeature("http://xml.org/sax/features/validation", false);
            factory.setFeature("http://apache.org/xml/features/validation/schema", false);
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);

            org.apache.jackrabbit.webdav.xml.DomUtil.setBuilderFactory(factory);
        } catch (Exception e) {
            throw new Error(e);
        }
    }
}
