package ru.yandex.chemodan.app.webdav.servlet;

import java.io.IOException;

import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.WebdavRequest;
import org.apache.jackrabbit.webdav.WebdavResponse;
import org.apache.jackrabbit.webdav.lock.DefaultActiveLock;
import org.apache.jackrabbit.webdav.lock.LockDiscovery;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.joda.time.Duration;

import ru.yandex.chemodan.app.webdav.repository.MpfsResource;

/**
 * @author tolmalev
 */
public class LockHandler implements DavMethodHandler {
    @Override
    public void handle(WebdavRequest request, WebdavResponse response, MpfsResource resource)
            throws IOException, DavException
    {
        try {
            DefaultActiveLock lock = new DefaultActiveLock();
            lock.setTimeout(Duration.standardDays(1).getMillis());
            response.addHeader("Lock-Token", lock.getToken());

            DavPropertySet prop = new DavPropertySet();
            prop.add(new LockDiscovery(lock));

            response.sendXmlResponse(prop, 200);
        } catch (RuntimeException e) {
            // bad lock request
            throw new DavException(400, e);
        }
    }

    @Override
    public String method() {
        return "LOCK";
    }
}
