package ru.yandex.chemodan.app.webdav.servlet;

import java.io.IOException;

import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.WebdavRequest;
import org.apache.jackrabbit.webdav.WebdavResponse;

import ru.yandex.chemodan.app.webdav.auth.AuthInfo;
import ru.yandex.chemodan.app.webdav.repository.MpfsResource;
import ru.yandex.chemodan.app.webdav.repository.MpfsResourceManager;
import ru.yandex.chemodan.app.webdav.repository.PathUtils;

/**
 * @author tolmalev
 */
public class MkColHandler extends DavHandlerBase {
    protected MkColHandler(MpfsResourceManager manager) {
        super(manager, "MKCOL");
    }

    @Override
    public void handle(WebdavRequest request, WebdavResponse response, MpfsResource resource)
            throws IOException, DavException
    {
        AuthInfo authInfo = getAuthInfo(request);

        boolean allowCreateSysDirs = authInfo.isOurClient();

        if (allowCreateSysDirs && "default".equals(request.getQueryString())) {
            String path = manager.mkSystemDir(resource.getUser(), resource.getDisplayName());
            response.addHeader("Location", PathUtils.encodePath(path));
        } else {
            manager.mkDir(resource.getUser(), resource.getRealPath());
        }
        response.setStatus(201);
    }
}
