package ru.yandex.chemodan.app.webdav.servlet;

import java.io.IOException;

import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.WebdavRequest;
import org.apache.jackrabbit.webdav.WebdavResponse;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.chemodan.app.webdav.auth.AuthInfo;
import ru.yandex.chemodan.app.webdav.repository.ComplexCallback;
import ru.yandex.chemodan.app.webdav.repository.MpfsResource;
import ru.yandex.chemodan.app.webdav.repository.MpfsResourceManager;
import ru.yandex.chemodan.app.webdav.repository.PathUtils;
import ru.yandex.misc.io.http.HttpStatus;
import ru.yandex.misc.web.servlet.HttpServletRequestX;

/**
 * @author tolmalev
 */
public class MoveHandler extends DavHandlerBase {
    protected MoveHandler(MpfsResourceManager manager) {
        super(manager, "MOVE");
    }

    @Override
    public void handle(WebdavRequest request, WebdavResponse response, MpfsResource resource)
            throws IOException, DavException
    {
        MpfsResource destResource = (MpfsResource) manager
                .createResource(request.getDestinationLocator(), request, response);

        SourcePaths sourcePaths = extractSourcePaths(request, resource);
        boolean isMultiple = sourcePaths.isMultiple();
        Tuple2List<String, String> srcAndDstPaths = zipWithDestPath(sourcePaths.getPaths(), destResource, isMultiple);

        AuthInfo authInfo = getAuthInfo(request);

        boolean doMkdirs = isMultiple && doMkdirs(request);
        boolean overwrite = !isMultiple && !HttpServletRequestX.wrap(request).getHeaderO("Overwrite").isSome("F");

        ListF<ComplexCallback.AsyncOperation> operations = srcAndDstPaths
                .map((srcPath, dstPath) -> new ComplexCallback.AsyncOperation(
                        PathUtils.href(srcPath, authInfo),
                        isMultiple ? HttpStatus.SC_200_OK : HttpStatus.SC_201_CREATED,
                        (ctx, operationId, callback) ->
                                manager.asyncMove(
                                        resource.getUser(),
                                        srcPath,
                                        dstPath,
                                        overwrite,
                                        getAuthInfo(request).isOurClient(),
                                        doMkdirs,
                                        callback
                                )
                ));

        applySingleOrComplex(request, operations, isMultiple);
    }
}
