package ru.yandex.chemodan.app.webdav.servlet;

import org.apache.http.client.config.RequestConfig;
import org.springframework.context.annotation.Bean;
import org.springframework.test.context.ContextConfiguration;

import ru.yandex.chemodan.boot.value.OverridableValuePrefix;
import ru.yandex.chemodan.util.http.HttpClientConfigurator;
import ru.yandex.chemodan.util.test.HttpRecorderRule;
import ru.yandex.misc.io.http.apache.v4.ApacheHttpClientUtils;

@ContextConfiguration
public class MpfsIndexMockConfiguration {

    @Bean
    @OverridableValuePrefix("mpfs.index")
    @DavHandlersContextConfiguration.MpfsIndex
    public HttpClientConfigurator mpfsIndexHttpClientConfigurator(HttpRecorderRule rule) {
        return new HttpClientConfigurator() {
            @Override
            public ApacheHttpClientUtils.Builder createBuilder() {
                return super.createBuilder().withRequestConfig(RequestConfig.custom().setProxy(rule.getHost()).build())
                        .withRoutePlanner(new HttpRecorderRule.CustomHttpsProxyRoutePlanner());
            }
        };
    }

}
