package ru.yandex.chemodan.app.webdav.servlet;

import java.io.ByteArrayInputStream;

import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.misc.test.Assert;

/**
 * @author tolmalev
 */
public class MultipleRequestTest {
    @Test
    public void parse() throws Exception {
        MultipleRequest parsed = MultipleRequest.parse(new ByteArrayInputStream(
                ("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n"
                        + "<multiple>\n"
                        + "  <resource path=\"rel/path/to/file1##??entity&gt; encoded&amp;\"/>\n"
                        + "  <resource>/absolute/path/%23%23%3F%3Furlencoded%26%3A)</resource>\n"
                        + "</multiple> ")
                        .getBytes())
        );

        Assert.equals(
                Cf.list("rel/path/to/file1##??entity> encoded&", "/absolute/path/##??urlencoded&:)"),
                parsed.paths
        );
    }
}
