package ru.yandex.chemodan.app.webdav.servlet;

import java.io.IOException;

import javax.servlet.http.HttpServletResponse;

import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.WebdavRequest;
import org.apache.jackrabbit.webdav.WebdavResponse;

import ru.yandex.chemodan.app.webdav.repository.MpfsResource;
import ru.yandex.chemodan.util.ping.CoolPingServlet;

/**
 * @author tolmalev
 */
public class PingHandler implements DavMethodHandler {

    private final CoolPingServlet servlet;

    public PingHandler(CoolPingServlet servlet) {
        this.servlet = servlet;
    }

    @Override
    public void handle(WebdavRequest request, WebdavResponse response, MpfsResource resource)
            throws IOException, DavException
    {
        if (servlet.isAvailable()) {
            response.getWriter().write("ok /ping");
        } else {
            response.sendError(HttpServletResponse.SC_BAD_GATEWAY);
        }
    }

    @Override
    public String method() {
        return "GET";
    }

    @Override
    public boolean matches(WebdavRequest request, MpfsResource resource) {
        return request.getParameter("ping") != null
                && (request.getPathInfo() == null
                || request.getPathInfo().equals("")
                || request.getPathInfo().equals("/")
                // android mobile application makes such request
                || request.getPathInfo().equals("//")
        );
    }

    @Override
    public int order() {
        return 1;
    }
}
