package ru.yandex.chemodan.app.webdav.servlet;

import java.io.IOException;
import java.util.List;

import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavServletResponse;
import org.apache.jackrabbit.webdav.MultiStatus;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.WebdavRequest;
import org.apache.jackrabbit.webdav.WebdavResponse;
import org.apache.jackrabbit.webdav.property.PropEntry;

import ru.yandex.chemodan.app.webdav.auth.AuthInfo;
import ru.yandex.chemodan.app.webdav.filter.AuthenticationFilter;
import ru.yandex.chemodan.app.webdav.repository.MpfsResource;
import ru.yandex.chemodan.app.webdav.repository.MpfsResourceManager;

/**
 * @author tolmalev
 */
public class ProppatchHandler implements DavMethodHandler {
    private final MpfsResourceManager manager;

    public ProppatchHandler(MpfsResourceManager manager) {
        this.manager = manager;
    }

    @Override
    public void handle(WebdavRequest request, WebdavResponse response, MpfsResource resource)
            throws DavException, IOException
    {
        if (!resource.exists()) {
            response.sendError(DavServletResponse.SC_NOT_FOUND);
            return;
        }

        AuthInfo authInfo = AuthenticationFilter.getAuthInfo(request);

        List<? extends PropEntry> changeList = request.getPropPatchChangeList();
        if (changeList.isEmpty()) {
            response.sendError(DavServletResponse.SC_BAD_REQUEST);
            return;
        }

        MultiStatus ms = new MultiStatus();
        MultiStatusResponse msr = manager.alterProperties(authInfo, resource, changeList);
        ms.addResponse(msr);
        response.sendMultiStatus(ms);
    }

    @Override
    public String method() {
        return "PROPPATCH";
    }
}
