package ru.yandex.chemodan.app.webdav.servlet;

import java.io.IOException;

import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.WebdavRequest;
import org.apache.jackrabbit.webdav.WebdavResponse;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.chemodan.app.webdav.repository.MpfsResource;
import ru.yandex.chemodan.app.webdav.repository.MpfsResourceManager;
import ru.yandex.misc.io.http.HttpStatus;
import ru.yandex.misc.ip.IpAddress;
import ru.yandex.misc.web.servlet.HttpServletRequestX;


/**
 * @author yashunsky
 */
public class PublishHandler extends DavHandlerBase {
    protected PublishHandler(MpfsResourceManager manager) {
        super(manager, "POST");
    }

    @Override
    public void handle(WebdavRequest request, WebdavResponse response, MpfsResource resource) throws IOException,
            DavException
    {
        switch (request.getQueryString()) {
            case "publish":
                IpAddress remoteIp = HttpServletRequestX.wrap(request).getRemoteIpAddress();
                String url = manager.publish(resource.getUser(), resource.getRealPath(), remoteIp);
                response.setHeader("Location", url);
                response.setStatus(HttpStatus.SC_302_MOVED_TEMPORARILY);
                break;
            case "unpublish":
                response.setStatus(manager.unpublish(resource.getUser(), resource.getRealPath()));
                break;
        }
    }

    @Override
    public boolean matches(WebdavRequest request, MpfsResource resource) {
        return Cf.list("publish", "unpublish").containsTs(request.getQueryString());
    }
}
