package ru.yandex.chemodan.app.webdav.servlet;

import java.io.IOException;

import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.WebdavRequest;
import org.apache.jackrabbit.webdav.WebdavResponse;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.webdav.repository.MpfsResource;
import ru.yandex.chemodan.app.webdav.repository.MpfsResourceManager;
import ru.yandex.misc.io.http.HttpStatus;

/**
 * @author yashunsky
 */
public class PushHandler extends DavHandlerBase {
    protected PushHandler(MpfsResourceManager manager) {
        super(manager, "POST");
    }

    @Override
    public void handle(WebdavRequest request, WebdavResponse response, MpfsResource resource) throws IOException,
            DavException
    {
        String pushRequestType = request.getParameter("push");
        String token = Option.ofNullable(request.getParameter("token")).getOrElse("");

        switch (pushRequestType) {
            case "subscribe":
            case "update":
                Option<String> allow = Option.ofNullable(request.getParameter("allow"));
                String resources;
                try {
                    resources = IOUtils.toString(request.getInputStream());
                } catch (IOException e) {
                    response.sendError(HttpStatus.SC_499_CLIENT_CLOSED_REQUEST);
                    break;
                }

                response.setStatus(manager.mobileSubscribe(resource.getUser(), token, allow, resources));
                break;
            case "unsubscribe":
                response.setStatus(manager.mobileUnsubscribe(resource.getUser(), token));
                break;
            default:
                response.sendError(HttpStatus.SC_405_METHOD_NOT_ALLOWED);
                break;
        }
    }

    @Override
    public boolean matches(WebdavRequest request, MpfsResource resource) {
        return request.getParameter("push") != null;
    }
}
