package ru.yandex.chemodan.app.webdav.servlet;

import java.io.IOException;

import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.WebdavRequest;
import org.apache.jackrabbit.webdav.WebdavResponse;

import ru.yandex.chemodan.app.webdav.repository.MpfsResource;
import ru.yandex.misc.io.http.HttpStatus;

/**
 * @author tolmalev
 */
public class RedirectToHelpHandler implements DavMethodHandler {
    @Override
    public void handle(WebdavRequest request, WebdavResponse response, MpfsResource resource)
            throws IOException, DavException
    {
        response.addHeader("Location", "https://help.yandex.ru/disk/webdav.xml");
        response.setStatus(HttpStatus.SC_302_MOVED_TEMPORARILY);
    }

    @Override
    public String method() {
        return "GET";
    }

    @Override
    public boolean matches(WebdavRequest request, MpfsResource resource) {
        return request.getParameterMap().isEmpty()
                && (request.getPathInfo() == null
                || request.getPathInfo().equals("")
                || request.getPathInfo().equals("/")
                // android mobile application makes such request
                || request.getPathInfo().equals("//")
        );
    }

    @Override
    public int order() {
        return 1;
    }
}
