package ru.yandex.chemodan.app.webdav.servlet;

import java.io.IOException;

import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.WebdavRequest;
import org.apache.jackrabbit.webdav.WebdavResponse;

import ru.yandex.chemodan.app.webdav.repository.MpfsInviteResource;
import ru.yandex.chemodan.app.webdav.repository.MpfsResource;
import ru.yandex.chemodan.mpfs.MpfsClient;

/**
 * @author tolmalev
 */
public class RejectInviteHandler implements DavMethodHandler {
    private final MpfsClient mpfsClient;

    public RejectInviteHandler(MpfsClient mpfsClient) {
        this.mpfsClient = mpfsClient;
    }

    @Override
    public void handle(WebdavRequest request, WebdavResponse response, MpfsResource resource)
            throws IOException, DavException
    {
        MpfsInviteResource invite = (MpfsInviteResource) resource;
        mpfsClient.rejectInvite(invite.getUser(), invite.getInvite().hash);
    }

    @Override
    public String method() {
        return "DELETE";
    }

    @Override
    public boolean matches(WebdavRequest request, MpfsResource resource) {
        return resource instanceof MpfsInviteResource;
    }

    @Override
    public int order() {
        return 1;
    }
}
