package ru.yandex.chemodan.app.webdav.servlet;

import java.io.IOException;

import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.WebdavRequest;
import org.apache.jackrabbit.webdav.WebdavResponse;

import ru.yandex.chemodan.app.webdav.repository.MpfsCallbackBase;
import ru.yandex.chemodan.app.webdav.repository.MpfsResource;
import ru.yandex.chemodan.app.webdav.repository.MpfsResourceManager;

/**
 * @author tolmalev
 */
public class TrashCleanHandler extends DavHandlerBase {

    protected TrashCleanHandler(MpfsResourceManager manager) {
        super(manager, "POST");
    }

    @Override
    public void handle(WebdavRequest request, WebdavResponse response, MpfsResource resource)
            throws IOException, DavException
    {
        withMpfsAsyncOperation(request, (ctx, opId) -> manager.asyncTrashClean(resource.getUser(), getAuthInfo(request).isOurClient(),
                new MpfsCallbackBase(ctx, opId, 200)));
    }

    @Override
    public boolean matches(WebdavRequest request, MpfsResource resource) {
        return "/trash".equals(resource.getRealPath())
                && "clean".equals(request.getQueryString())
                && getAuthInfo(request).isOurClient();
    }

    @Override
    public int order() {
        return 1;
    }
}
