package ru.yandex.chemodan.app.webdav.servlet;

import java.net.URI;
import java.net.URISyntaxException;

import org.eclipse.jetty.http.HttpURI;
import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.misc.io.http.UrlUtils;
import ru.yandex.misc.test.Assert;

/**
 * @author dbrylev
 */
public class UriParserTest {

    @Test
    public void parseLikeAJetty() {
        ListF<String> urls = Cf.list(
                "http://ya.ru/\\\\%3A%D0%91%D1%80",
                "http://ya.ru/%253A%25D0%2591%25D1%2580\\",
                "http://ya.ru/Ð\\u0098Ð½Ñ\\u0084Ð¾Ñ",
                "http://ya.ru/Ð\u0098Ð½Ñ\u0084Ð¾Ñ",
                "http://ya.ru/CA Klanten+/2018");

        urls.forEach(url -> {
            Assert.assertThrows(() -> new URI(url), URISyntaxException.class);

            Assert.equals(
                    UrlUtils.urlDecode(new HttpURI(url).getPath()),
                    UrlUtils.urlDecode(UriParser.parseLikeAJetty(url).getRawPath()));
        });
    }
}
