package ru.yandex.chemodan.app.webdav.servlet;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.chemodan.app.webdav.auth.AuthInfo;
import ru.yandex.chemodan.mpfs.MpfsUser;
import ru.yandex.chemodan.mpfs.MpfsUserInitParamsExtractor;

/**
 * @author dbrylev
 */
public class WebDavUserInitParamsExtractor implements MpfsUserInitParamsExtractor {

    @Override
    public Tuple2List<String, String> extract(MpfsUser user) {
        if (user instanceof AuthInfo) {
            AuthInfo auth = (AuthInfo) user;

            return Tuple2List.<String, String>tuple2List()
                    .plus(Option.of("locale").zip(auth.lang))
                    .plus(Option.of("os").zip(auth.ourClient.map(o -> o.os)))
                    .plus1("source", "webdav-" + auth.authType.name().toLowerCase());
        }
        return Tuple2List.tuple2List();
    }
}
