package ru.yandex.chemodan.app.webdav.servlet;

import java.util.Objects;

import javax.servlet.http.HttpServletRequest;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.webdav.auth.OurClient;
import ru.yandex.chemodan.util.web.CustomYcridPrefixResolver;
import ru.yandex.misc.io.http.HttpHeaderNames;

/**
 * @author yashunsky
 */
public class WebdavYcridPrefixResolver implements CustomYcridPrefixResolver {

    private static final MapF<String, String> platforms = Cf.<String, String>map()
            .plus1("android", "andr")
            .plus1("iOS", "ios")
            .plus1("wp", "wp")
            .plus1("windows", "win")
            .plus1("win8", "win")
            .plus1("winrt", "win")
            .plus1("mac", "mac")
            .plus1("macstore", "mac")
            .plus1("cli", "lnx")
            .unmodifiable();

    public String getPrefix(HttpServletRequest request) {
        Option<String> platform = Option.ofNullable(request.getHeader(HttpHeaderNames.USER_AGENT))
                .filterMap(OurClient::parseUserAgent).map(oc -> oc.platform);
        boolean isSdk = Objects.nonNull(request.getHeader("X-Yandex-Sdk-Version"));

        return platform
                .map(p -> platforms.getOrElse(p, isSdk ? "sdksw" : "sw"))
                .getOrElse(isSdk ? "sdk" : "dav");
    }
}
