package ru.yandex.chemodan.app.webdav.servlet.index;

import java.io.IOException;
import java.io.InputStream;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.misc.codec.Hex;
import ru.yandex.misc.lang.CharsetUtils;
import ru.yandex.misc.lang.Check;

/**
 * @author tolmalev
 */
public class MpfsIndexReader {
    static String readIndex(String version, ListF<String> ext, InputStream in) throws IOException {
        StringBuilder sb = new StringBuilder();

        long type = readInt(in);
        try {
            while (type >= 0) {
                sb.append("TYPE = ").append(type).append(": ");

                switch ((int) type & 0b11) {
                    case 0:
                        sb.append("Removed: ");
                        sb.append("path = ").append(readString(in));
                        break;

                    case 1:
                        sb.append("Created file:");
                        if ("1".equals(version)) {
                            sb.append(" fid = ").append(readString(in)).append(",");
                        }

                        sb
                                .append(" md5 = ").append(Hex.encode(readBytes(16, in)))
                                .append(" sha256 = ").append(Hex.encode(readBytes(32, in)))
                                .append(" size = ").append(readInt(in));

                        String path = readString(in);
                        sb
                                .append(" path = ").append(path);

                        if ("1".equals(version) && ext.containsTs("media")) {
                            sb
                                    .append(", mtime = ").append(readInt(in))
                                    .append(", etime = ").append(readInt(in))
                                    .append(", media_type = ").append(readString(in))
                                    .append(", mimetype = ").append(readString(in));
                        }
                        break;

                    case 2:
                        sb.append("Created dir: ");
                        if ("1".equals(version)) {
                            sb.append("fid = ").append(readString(in)).append(", ");
                        }
                        sb.append("path = ").append(readString(in));

                        break;

                    case 3:
                        sb.append("Operation 3: ").append(readString(in));

                        break;

                    default:
                        Check.fail("Unknown operation: " + ((int) type & 0b11));
                }

                sb.append("\n");

                type = readInt(in);
            }
        } catch (RuntimeException e) {
            System.err.println(sb.toString());
            throw e;
        }
        return sb.toString();
    }

    private static byte[] readBytes(int length, InputStream in) throws IOException {
        byte[] bytes = new byte[length];
        int read = in.read(bytes);

        Check.equals(length, read);

        return bytes;
    }

    private static String readString(InputStream in) throws IOException {
        int length = (int) readInt(in);
        return new String(readBytes(length, in), CharsetUtils.UTF8_CHARSET);
    }

    private static long readInt(InputStream in) throws IOException {
        long result = 0;
        int part;
        int i = 0;

        do {
            part = in.read();
            if (part < 0) {
                return -1;
            }

            result += (part & 127) << (7 * i);
            i++;
        } while (part >= 128);
        return result;
    }
}
