package ru.yandex.chemodan.app.worker2;

import org.junit.Test;

import ru.yandex.chemodan.OnetimeTaskUtils;
import ru.yandex.chemodan.core.worker.tasks.RegenerateImagePreview;
import ru.yandex.chemodan.core.worker.tasks.RegeneratePreviewParameters;
import ru.yandex.chemodan.core.worker.tasks.ShellOnetime;
import ru.yandex.chemodan.core.worker.tasks.ShellOnetime2;
import ru.yandex.chemodan.core.worker.tasks.ShellOnetimeParameters;
import ru.yandex.commune.bazinga.impl.TaskId;
import ru.yandex.misc.test.Assert;

/**
 * @author dbrylev
 */
public class OnetimeTaskUtilsTest {

    @Test
    public void makeOnetimeTask() {
        ShellOnetime task = (ShellOnetime) OnetimeTaskUtils.makeOnetimeTask(
                new TaskId("shellOnetime"), "{\"command\": [\"rm -rf /\"]}");

        Assert.equals("rm -rf /", task.getParametersTyped().command.single());
    }

    @Test
    public void getParametersClass() {
        Assert.equals(ShellOnetimeParameters.class,
                OnetimeTaskUtils.getParametersClass(ShellOnetime.class));

        Assert.equals(ShellOnetimeParameters.class,
                OnetimeTaskUtils.getParametersClass(ShellOnetime2.class));

        Assert.equals(RegeneratePreviewParameters.class,
                OnetimeTaskUtils.getParametersClass(RegenerateImagePreview.class));
    }
}
