package ru.yandex.chemodan.app.worker2;

import org.joda.time.Duration;

import ru.yandex.chemodan.app.worker2.queued.LongTasksManager;
import ru.yandex.commune.bazinga.scheduler.CronTask;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.schedule.Schedule;
import ru.yandex.commune.bazinga.scheduler.schedule.ScheduleDelay;
import ru.yandex.commune.bazinga.scheduler.schedule.ScheduleWithRetry;

/**
 * @author tolmalev
 */
public class ProcessLongTasks extends CronTask {
    private final LongTasksManager longTasksManager;

    public ProcessLongTasks(LongTasksManager longTasksManager) {
        this.longTasksManager = longTasksManager;
    }

    @Override
    public Schedule cronExpression() {
        return new ScheduleWithRetry(new ScheduleDelay(Duration.standardMinutes(10)), 50);
    }

    @Override
    public Duration timeout() {
        return Duration.standardHours(1);
    }

    @Override
    public void execute(ExecutionContext executionContext) throws Exception {
        longTasksManager.processLongTasks();
    }
}
