package ru.yandex.chemodan.app.worker2;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.chemodan.bazinga.PgBazingaFetcherConfigurationContextConfiguration;
import ru.yandex.chemodan.bazinga.PgBazingaStorageConfigurationContextConfiguration;
import ru.yandex.commune.bazinga.pg.context.PgBazingaClientContextConfiguration;
import ru.yandex.commune.bazinga.pg.context.PgBazingaContextConfiguration;
import ru.yandex.commune.bazinga.pg.worker.PgBazingaWorkerConfiguration;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;

/**
 * @author dbrylev
 */
@Configuration
@Import({
        WorkerBazingaCoreContextConfiguration.class,
        PgBazingaFetcherConfigurationContextConfiguration.class,
        PgBazingaStorageConfigurationContextConfiguration.class,
        PgBazingaContextConfiguration.class,
        PgBazingaClientContextConfiguration.class,
})
public class Worker2BazingaCoreContextConfiguration {

    @Bean
    public PgBazingaWorkerConfiguration pgBazingaWorkerConfiguration() {
        return new PgBazingaWorkerConfiguration(Cf.list(TaskQueueName.CRON));
    }
}
