package ru.yandex.chemodan.app.worker2;

import org.joda.time.Duration;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.bazinga.JobsCleaningRegistryContextConfiguration;
import ru.yandex.commune.bazinga.pg.context.PgBazingaMaintenanceContextConfiguration;
import ru.yandex.commune.bazinga.pg.storage.WorkerIdCondition;
import ru.yandex.commune.bazinga.pg.storage.maintenance.CleanJobsConfiguration;
import ru.yandex.commune.bazinga.pg.storage.maintenance.PgBazingaMaintenanceConfiguration;
import ru.yandex.commune.bazinga.pg.storage.maintenance.RestoreJobsConfiguration;
import ru.yandex.commune.bazinga.pg.storage.maintenance.UpdateJobCountersConfiguration;
import ru.yandex.commune.dynproperties.DynamicProperty;

/**
 * @author dbrylev
 * @author yashunsky
 */
@Configuration
@Import({
        WorkerBazingaTasksContextConfiguration.class,
        JobsCleaningRegistryContextConfiguration.class,
        PgBazingaMaintenanceContextConfiguration.class,
})
public class Worker2BazingaTasksContextConfiguration {

    private final DynamicProperty<Integer> cleanJobsBatchSize = new DynamicProperty<>(
            "bazinga.jobs-cleaning.chunk-size", 1000);

    private final DynamicProperty<Integer> restoreAttemptsToConnectWorker = new DynamicProperty<>(
            "bazinga.restore-started-jobs.attempts-to-connect-worker", 3);

    private final DynamicProperty<Integer> restoreAttemptIntervalSeconds = new DynamicProperty<>(
            "bazinga.restore-started-jobs.attempt-interval-seconds", 60);

    private final DynamicProperty<Integer> restoreStartedBeforeSeconds = new DynamicProperty<>(
            "bazinga.restore-started-jobs.started-before-seconds", 2 * 60);

    @Bean
    public PgBazingaMaintenanceConfiguration bazingaMaintenanceConfiguration(
            @Value("${bazinga.storage.cleaner.expire.days:-30}") int expireDays,
            @Value("${bazinga.storage.update-job-counters.threads-per-shard}") int threadsPerShard,
            @Value("${bazinga.storage.update-job-counters.duration}") Duration singleRunDuration,
            @Value("${bazinga.storage.update-job-counters.timeout-offset}") Duration timeoutOffset,
            @Value("${bazinga.storage.update-job-counters.limit}") int limit,
            @Value("${bazinga.storage.update-job-counters.enabled}") boolean enabled)
    {
        return new PgBazingaMaintenanceConfiguration(
                new CleanJobsConfiguration(cleanJobsBatchSize::get, () -> Duration.standardDays(expireDays)),
                new RestoreJobsConfiguration(restoreAttemptsToConnectWorker::get,
                        () -> Duration.standardSeconds(restoreAttemptIntervalSeconds.get()),
                        () -> Duration.standardSeconds(restoreStartedBeforeSeconds.get()),
                        WorkerIdCondition.portEq(28702)),
                new UpdateJobCountersConfiguration(threadsPerShard, singleRunDuration, timeoutOffset, limit, enabled),
                Option.empty());
    }
}
