package ru.yandex.chemodan.app.worker2;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.app.worker2.admin.Worker2AdminContextConfiguration;
import ru.yandex.chemodan.app.worker2.api.PgTasksApiContextConfiguration;
import ru.yandex.chemodan.app.worker2.export.BlockedStidsExportContextConfiguration;
import ru.yandex.chemodan.app.worker2.stat.YqlStatContextConfiguration;
import ru.yandex.chemodan.app.worker2.wakeup.WakeUpPushContextConfig;
import ru.yandex.chemodan.app.worker2.xiva.XivaPushContextConfiguration;
import ru.yandex.chemodan.bazinga.dynamic.DynamicCronTasksContextConfiguration;
import ru.yandex.chemodan.boot.DiskAppVersion;
import ru.yandex.commune.a3.action.result.ApplicationInfo;
import ru.yandex.misc.version.AppName;

/**
 * @author dbrylev
 * @author yashunsky
 */
@Configuration
@Import({
        Worker2BazingaCoreContextConfiguration.class,
        Worker2BazingaTasksContextConfiguration.class,
        WorkerJettyContextConfiguration.class,
        Worker2AdminContextConfiguration.class,
        PgTasksApiContextConfiguration.class,
        BlockedStidsExportContextConfiguration.class,
        DynamicCronTasksContextConfiguration.class,
        YqlStatContextConfiguration.class,
        XivaPushContextConfiguration.class,
        WakeUpPushContextConfig.class
})
public class Worker2ContextConfiguration {

    @Bean
    public ApplicationInfo applicationInfo(AppName appName, DiskAppVersion appVersion) {
        return new ApplicationInfo(appName.appName(), appVersion.getProjectVersion());
    }
}
