package ru.yandex.chemodan.app.worker2;

import org.springframework.context.ConfigurableApplicationContext;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.boot.ChemodanCommonContextConfiguration;
import ru.yandex.chemodan.boot.ChemodanMainSupport;
import ru.yandex.chemodan.core.worker.python.CronTasksConfigReader;
import ru.yandex.chemodan.core.worker.python.onetime.OnetimeTaskReader;
import ru.yandex.misc.db.monica.JdbcMetricsSwitch;
import ru.yandex.misc.version.AppName;
import ru.yandex.misc.version.SimpleAppName;

/**
 * @author dbrylev
 */
public class Worker2Main extends ChemodanMainSupport {

    public static void main(String[] args) {
        JdbcMetricsSwitch.ENABLED = true;
        JdbcMetricsSwitch.COMMAND_METRICS_ENABLED = true;
        new Worker2Main().runMain(args);
    }

    @Override
    public ListF<Class<?>> applicationSpecificContextPath() {
        return Cf.list(
                ChemodanCommonContextConfiguration.class,
                Worker2ContextConfiguration.class);
    }

    @Override
    protected void postProcessApplicationContextBeforeRefresh(ConfigurableApplicationContext context) {
        super.postProcessApplicationContextBeforeRefresh(context);
        CronTasksConfigReader.registerConfigurableCronTasksFromConfig(context);
        OnetimeTaskReader.registerConfigurableOnetimeTasksFromConfig(context);
    }

    public AppName applicationName() {
        return new SimpleAppName("disk", "worker2");
    }

}
