package ru.yandex.chemodan.app.worker2;

import javax.annotation.PostConstruct;

import com.mongodb.MongoClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.admin.web.AdminApp;
import ru.yandex.commune.mongo.admin.browser.MongoBrowserAdminPage;
import ru.yandex.commune.mongo.admin.schema.MongoSchemaCheckerAdminContextConfiguration;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author Lev Tolmachev
 */
@Configuration
@Import(MongoSchemaCheckerAdminContextConfiguration.class)
public class WorkerAdminContextConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(WorkerAdminContextConfiguration.class);

    @Autowired
    @Qualifier("bazingaMongoClient")
    private MongoClient mongoClient;

    @Autowired
    private AdminApp adminApp;

    @PostConstruct
    public void initWorkerAdmin() {
        adminApp.registerAdminPage("Bazinga mongoDB browser", Option.of("DB"), new MongoBrowserAdminPage(mongoClient));
    }
}
