package ru.yandex.chemodan.app.worker2;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.worker2.stat.RecalcYqlStatOnetimeTask;
import ru.yandex.chemodan.bazinga.BazingaControllerConfigurationContextConfiguration;
import ru.yandex.chemodan.bazinga.BazingaWorkerConfigurationContextConfiguration;
import ru.yandex.chemodan.bazinga.BazingaWorkerTaskQueues;
import ru.yandex.chemodan.core.worker.python.onetime.ConfigurableOnetimeTaskRegistry;
import ru.yandex.chemodan.core.worker.tasks.RegenerateDocumentPreview;
import ru.yandex.chemodan.core.worker.tasks.RegenerateImagePreview;
import ru.yandex.chemodan.core.worker.tasks.RegenerateVideoPreview;
import ru.yandex.chemodan.core.worker.tasks.ShellOnetime;
import ru.yandex.chemodan.core.worker.tasks.ShellOnetime2;
import ru.yandex.commune.bazinga.admin.BazingaAdminAddressResolver;
import ru.yandex.commune.bazinga.admin.BazingaAdminAddressResolverStandard;
import ru.yandex.commune.bazinga.context.BazingaContextConfiguration;
import ru.yandex.commune.bazinga.scheduler.TaskQueue;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.misc.version.AppName;

/**
 * @author dbrylev
 */
@Configuration
@Import({
        BazingaContextConfiguration.class,
        BazingaControllerConfigurationContextConfiguration.class,
        BazingaWorkerConfigurationContextConfiguration.class,
})
public class WorkerBazingaCoreContextConfiguration {

    @Bean
    public BazingaAdminAddressResolver bazingaAdminAddressResolver(AppName appName) {
        return new BazingaAdminAddressResolverStandard(appName.serviceName() + "-" + appName.appName());
    }

    @Bean
    public ConfigurableOnetimeTaskRegistry configurableOnetimeTaskRegistry() {
        return new ConfigurableOnetimeTaskRegistry();
    }

    @Bean
    public BazingaWorkerTaskQueues taskQueues(
            @Value("${bazinga.worker.shell-onetime.count}")
            int shellOnetimeCount,
            @Value("${bazinga.worker.shell-onetime.queue}")
            int shellOnetimeQueue,
            @Value("${bazinga.worker.regenerate-image-preview.count}")
            int imagePreviewCount,
            @Value("${bazinga.worker.regenerate-image-preview.queue}")
            int imagePreviewQueue,
            @Value("${bazinga.worker.regenerate-video-preview.count}")
            int videoPreviewCount,
            @Value("${bazinga.worker.regenerate-video-preview.queue}")
            int videoPreviewQueue,
            @Value("${bazinga.worker.regenerate-document-preview.count}")
            int documentPreviewCount,
            @Value("${bazinga.worker.regenerate-document-preview.queue}")
            int documentPreviewQueue,
            @Value("${bazinga.worker.yql-stat.count}")
            int yqlStatCount,
            ConfigurableOnetimeTaskRegistry configurableOnetimeTaskRegistry)
    {
        ListF<TaskQueue> specific = Cf.list(
                new TaskQueue(ShellOnetime.TASK_QUEUE_NAME, shellOnetimeCount, shellOnetimeQueue),
                new TaskQueue(ShellOnetime2.TASK_QUEUE_NAME, shellOnetimeCount, shellOnetimeQueue),
                new TaskQueue(RegenerateImagePreview.TASK_QUEUE_NAME, imagePreviewCount, imagePreviewQueue),
                new TaskQueue(RegenerateVideoPreview.TASK_QUEUE_NAME, videoPreviewCount, videoPreviewQueue),
                new TaskQueue(RegenerateDocumentPreview.TASK_QUEUE_NAME, documentPreviewCount, documentPreviewQueue),
                new TaskQueue(RecalcYqlStatOnetimeTask.TASK_QUEUE_NAME, yqlStatCount, yqlStatCount)
        );

        specific = specific.plus(configurableOnetimeTaskRegistry.getTasks()
                .map(task -> new TaskQueue(task.queueName(), task.getThreadCount(), task.getQueueCount())));

        return new BazingaWorkerTaskQueues(
                TaskQueueName.CRON, TaskQueueName.REGULAR, TaskQueueName.CPU_INTENSIVE, specific);
    }
}
