package ru.yandex.chemodan.app.worker2;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.chemodan.app.worker2.export.GetBlockedStidsServlet;
import ru.yandex.chemodan.util.ping.CoolPingServlet;
import ru.yandex.commune.bazinga.BazingaTaskManager;
import ru.yandex.commune.bazinga.impl.storage.BazingaStorage;
import ru.yandex.misc.web.servlet.WtdFilter;
import ru.yandex.misc.web.servletContainer.SingleWarJetty;

/**
 * @author dbrylev
 */
@Configuration
public class WorkerJettyContextConfiguration {

    @Bean
    public OnetimeTaskServlet onetimeTaskServlet(
            BazingaTaskManager bazingaTaskManager,
            BazingaStorage bazingaStorage)
    {
        return new OnetimeTaskServlet(bazingaTaskManager, bazingaStorage);
    }

    @Bean
    public GetBlockedStidsServlet getBlockedStidsServlet() {
        return new GetBlockedStidsServlet();
    }

    @Bean
    public SingleWarJetty taskJetty(
            @Value("${worker.task.http.port}") int httpPort,
            @Value("${worker.task.http.maxThreads:-1000}") int maxThreads,
            @Value("${worker.task.http.maxQueueLength:-1000}") int maxQueueLength,
            OnetimeTaskServlet onetimeTaskServlet,
            GetBlockedStidsServlet getBlockedStidsServlet,
            CoolPingServlet coolPingServlet)
    {
        SingleWarJetty jetty = new SingleWarJetty();
        jetty.setHttpPort(httpPort);
        jetty.setMaxThreads(maxThreads);
        jetty.setMaxQueueLength(maxQueueLength);
        jetty.setCopyBeanPostprocessors(true);
        jetty.setLookupServletsInContext(false);
        jetty.addFilterMapping("/*", new WtdFilter());

        jetty.addServletMapping("/onetime-task/*", onetimeTaskServlet);
        jetty.addServletMapping(GetBlockedStidsServlet.HANDLE_PATH + "/*", getBlockedStidsServlet);
        jetty.addServletMapping("/ping/*", coolPingServlet);

        return jetty;
    }
}
