package ru.yandex.chemodan.app.worker2.admin;

import javax.annotation.PostConstruct;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.admin.common.CommonLocator;
import ru.yandex.chemodan.admin.lib.LibLocator;
import ru.yandex.chemodan.app.worker2.admin.cleaner.JobsCleanerAdminPage;
import ru.yandex.chemodan.bazinga.CompoundBazingaAdminAddressResolverContextConfiguration;
import ru.yandex.chemodan.bazinga.JobsCleaningRegistry;
import ru.yandex.chemodan.bazinga.JobsCleaningRegistryContextConfiguration;
import ru.yandex.chemodan.bazinga.dynamic.DynamicCronTasksAdminPage;
import ru.yandex.chemodan.bazinga.dynamic.DynamicCronTasksManager;
import ru.yandex.commune.admin.web.AdminApp;
import ru.yandex.commune.zk2.admin.ZkAdminContextConfiguration;

/**
 * @author yashunsky
 */

@Configuration
@Import({
        ZkAdminContextConfiguration.class,
        JobsCleaningRegistryContextConfiguration.class,
        CompoundBazingaAdminAddressResolverContextConfiguration.class,
})
public class Worker2AdminContextConfiguration {
    @Autowired
    private AdminApp adminApp;

    @PostConstruct
    public void init() {
        adminApp.registerHiddenAdminPage("lib", new LibLocator());
        adminApp.registerHiddenAdminPage("common", new CommonLocator());
    }

    @Bean
    public JobsCleanerAdminPage jobsCleanerAdminPage(
            JobsCleaningRegistry jobsCleaningRegistry,
            DynamicCronTasksManager dynamicCronTasksManager)
    {
        JobsCleanerAdminPage jobsCleanerAdminPage = new JobsCleanerAdminPage(jobsCleaningRegistry);
        DynamicCronTasksAdminPage dynamicCronTasksAdminPage = new DynamicCronTasksAdminPage(dynamicCronTasksManager);

        adminApp.registerAdminPage("Jobs cleaning", Option.of("Db"), jobsCleanerAdminPage);
        adminApp.registerAdminPage("", Option.of("Bazinga Cron"), dynamicCronTasksAdminPage);

        return jobsCleanerAdminPage;
    }

}
