package ru.yandex.chemodan.app.worker2.admin.cleaner;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.worker2.admin.common.AdminBenderParameterBinder;
import ru.yandex.chemodan.bazinga.JobsCleaningRegistry;
import ru.yandex.commune.a3.action.ActionContainer;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.BindWith;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.commune.a3.action.result.NoContent;
import ru.yandex.commune.admin.z.ZAction;
import ru.yandex.commune.admin.z.ZRedirectException;
import ru.yandex.commune.bazinga.impl.TaskId;
import ru.yandex.commune.bazinga.pg.storage.maintenance.TaskCleanupSettings;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.XmlRootElement;

/**
 * @author yashunsky
 */

@ActionContainer
public class JobsCleanerAdminPage {
    private final JobsCleaningRegistry registry;

    public JobsCleanerAdminPage(JobsCleaningRegistry registry) {
        this.registry = registry;
    }

    @ZAction(defaultAction = true)
    @Path("/jobs-cleaner")
    public CleanerPojo index() {
        return new CleanerPojo(registry.getAll().toList());
    }

    @Path("/jobs-cleaner/task")
    public TaskCleanupSettings get(@RequestParam("id") String id) {
        TaskId taskId = new TaskId(id);
        return registry.getO(taskId).getOrElse(registry.getEmpty(taskId));
    }

    @Path(value = "/jobs-cleaner/task", methods = HttpMethod.POST)
    public NoContent save(@BindWith(AdminBenderParameterBinder.class) TaskCleanupSettings cleaningSetup) {
        registry.put(cleaningSetup);

        return NoContent.cons();
    }

    @Path("/jobs-cleaner/delete")
    public void delete(@RequestParam("id") String id) {
        registry.remove(new TaskId(id));

        throw new ZRedirectException("/z/jobs-cleaner");
    }

    @XmlRootElement(name = "content")
    @BenderBindAllFields
    public static class CleanerPojo {
        public final ListF<TaskCleanupSettings> ttls;
        public final boolean defaultUndefined;
        public final String defaultSetupName;

        public CleanerPojo(ListF<TaskCleanupSettings> ttls) {
            this.ttls = ttls;
            defaultSetupName = JobsCleaningRegistry.DEFAULT_SETUP_NAME.toString();
            defaultUndefined = !ttls.map(setup -> setup.id).containsTs(new TaskId(defaultSetupName));
        }
    }
}
