package ru.yandex.chemodan.app.worker2.admin.common;

import org.joda.time.Duration;

import ru.yandex.chemodan.util.bender.HumanReadableDurationUnmarshaller;
import ru.yandex.commune.a3.action.parameter.bind.BenderParameterBinder;
import ru.yandex.misc.bender.BenderMapper;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.config.BenderConfiguration;
import ru.yandex.misc.bender.config.BenderSettings;
import ru.yandex.misc.bender.config.CustomMarshallerUnmarshallerFactoryBuilder;
import ru.yandex.misc.bender.custom.DurationAsMillisMarshaller;

/**
 * @author yashunsky
 */
public class AdminBenderParameterBinder extends BenderParameterBinder {
    public static final BenderConfiguration configuration = new BenderConfiguration(
            new BenderSettings(MembersToBind.WITH_ANNOTATIONS),
            CustomMarshallerUnmarshallerFactoryBuilder.cons()
                    .add(Duration.class, new DurationAsMillisMarshaller(), new HumanReadableDurationUnmarshaller())
                    .build());

    public static final BenderMapper mapper = new BenderMapper(configuration);

    public AdminBenderParameterBinder() {
        super(mapper);
    }
}
