package ru.yandex.chemodan.app.worker2.api;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.worker2.WorkerJettyContextConfiguration;
import ru.yandex.chemodan.bazinga.ChemodanBazingaClientContextConfiguration;
import ru.yandex.chemodan.bazinga.http.PgTasksActionConfigurator;
import ru.yandex.chemodan.bazinga.http.PgTasksActionContainer;
import ru.yandex.chemodan.core.worker.python.onetime.ConfigurableOnetimeTaskRegistry;
import ru.yandex.commune.a3.ActionApp;
import ru.yandex.commune.a3.action.result.ApplicationInfo;
import ru.yandex.commune.bazinga.pg.PgBazingaTaskManager;
import ru.yandex.commune.bazinga.pg.storage.PgBazingaStorage;
import ru.yandex.misc.web.servletContainer.SingleWarJetty;

/**
 * @author yashunsky
 */
@Configuration
@Import({
        ChemodanBazingaClientContextConfiguration.class,
        WorkerJettyContextConfiguration.class,
})
public class PgTasksApiContextConfiguration {

    @Bean
    public ConfigurableOnetimeTaskRegistry configurableOnetimeTaskRegistry() {
        return new ConfigurableOnetimeTaskRegistry();
    }

    @Bean
    public ActionApp actionApp(ApplicationInfo applicationInfo,
            ConfigurableOnetimeTaskRegistry configurableOnetimeTaskRegistry,
            PgBazingaStorage storage,
            PgBazingaTaskManager taskManager,
            SingleWarJetty taskJetty,
            @Value("${worker2.task.bulk-add.pool-size}") int poolSize)
    {
        ListF<Object> actions = Cf.list(
                new PgTasksActionContainer(configurableOnetimeTaskRegistry, storage, taskManager, poolSize)
        );
        ActionApp actionApp = PgTasksActionConfigurator.configure(applicationInfo, actions);

        taskJetty.addServletMapping("/tasks/*", actionApp.createServlet());

        return actionApp;
    }
}
