package ru.yandex.chemodan.app.worker2.export;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.ReadPreference;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author akirakozov
 */
public class BlockedFileDao {
    private static final Logger logger = LoggerFactory.getLogger(BlockedFileDao.class);

    private final DBCollection dbCollection;
    private int batchSize;

    public BlockedFileDao(DBCollection dbCollection, int batchSize) {
        this.dbCollection = dbCollection;
        this.batchSize = batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public SetF<String> getAllBlockedStids() {
        SetF<String> blockedStids = Cf.hashSet();

        BasicDBObject fields = new BasicDBObject("data.stids", true);
        BasicDBObject query = new BasicDBObject("data.stids", new BasicDBObject("$exists", true).append("$ne", null));

        DBCursor iter = dbCollection.find(query, fields).hint("data.stids_1")
                .batchSize(batchSize).setReadPreference(ReadPreference.secondary());

        while (iter.hasNext()) {
            DBObject o = iter.next();
            try {
                BasicDBObject data = (BasicDBObject) o.get("data");
                BasicDBList stids = (BasicDBList) data.get("stids");
                for (Object stid : stids){
                    blockedStids.add((String) stid);
                }
            } catch (Exception e) {
                logger.debug("Couldn't process record: " + o);
            }
        }

        return blockedStids;
    }
}
