package ru.yandex.chemodan.app.worker2.export;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.MongoClient;
import org.joda.time.Instant;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.chemodan.util.test.AbstractTest;
import ru.yandex.inside.admin.conductor.ConductorContextConfiguration;
import ru.yandex.misc.random.Random2;
import ru.yandex.misc.test.Assert;

@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(classes = {
        ExportBlockedFilesConfiguration.class,
        ConductorContextConfiguration.class})
public class BlockedFileDaoTest extends AbstractTest {

    @Autowired
    @Qualifier("mpfsMongo")
    private MongoClient mongoClient;

    @Autowired
    private BlockedFileDao blockedFileDao;

    @Ignore
    @Test
    public void getBlockedStids() {
        SetF<String> blockedStids = blockedFileDao.getAllBlockedStids();
        Assert.in("1000004.yadisk:1260145.3983296384113870897333404302967", blockedStids);
        Assert.in("1000004.yadisk:preview.249690056375959106114196944070", blockedStids);
    }

    @Ignore
    @Test
    public void generateBlockedStids() {
        DBCollection coll = mongoClient.getDB("mpfs_dev").getCollection("support_mpfs");
        for (int i = 0; i < 30; i++) {
            addGeneratedBlockedFile(coll);
        }
    }

    private void addGeneratedBlockedFile(DBCollection coll) {
        BasicDBList stids = new BasicDBList();
        stids.add(Random2.R.nextAlnum(10));
        stids.add(Random2.R.nextAlnum(10));

        MapF<String, Object> data = Cf.<String, Object>map("moderator", "test")
                .plus1("comment", "bad")
                .plus1("ctime", (int) Instant.now().getMillis())
                .plus1("uid", 123)
                .plus1("address", "/disk/test.txt")
                .plus1("stids", stids);

        coll.insert(new BasicDBObject(Cf.map("data", new BasicDBObject(data), "uid", 123)));
    }
}
