package ru.yandex.chemodan.app.worker2.export;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.boot.value.OverridableValuePrefix;
import ru.yandex.chemodan.util.http.HttpClientConfigurator;

/**
 * @author dbrylev
 */
@Configuration
@Import({
        ExportBlockedFilesConfiguration.class,
})
public class BlockedStidsExportContextConfiguration {

    @Bean
    public BlockedStidsExporter blockedStidsExporter() {
        return new BlockedStidsExporter(blockedStidsExporterHttpClientConfigurator().configure());
    }

    @Bean
    public BlockedStidsExportWorker blockedStidsExportWorker() {
        return new BlockedStidsExportWorker();
    }

    @Bean
    @OverridableValuePrefix("blocked_stids_exporter")
    public HttpClientConfigurator blockedStidsExporterHttpClientConfigurator() {
        return new HttpClientConfigurator();
    }
}
