package ru.yandex.chemodan.app.worker2.export;

import org.joda.time.Duration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.misc.io.file.File2;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.random.Random2;
import ru.yandex.misc.worker.spring.DelayingWorkerServiceBeanSupport;

/**
 * @author akirakozov
 */
public class BlockedStidsExportWorker extends DelayingWorkerServiceBeanSupport {
    private static final Logger logger = LoggerFactory.getLogger(BlockedStidsExportWorker.class);

    @Value("${blocked.stids.export.dir}")
    private File2 exportDir;
    @Value("${blocked.stids.export.file}")
    private String exportStidsFileName;


    @Value("${blocked.stids.export.delay}")
    @Override
    public void setDelay(Duration delay) {
        super.setDelay(delay);
    }

    @Override
    protected boolean defaultSleepBeforeFirstRun() {
        return false;
    }

    @Autowired
    BlockedStidsExporter blockedStidsExporter;

    @Override
    protected void execute() throws Exception {
        logger.debug("Start extracting blocked stids");

        ListF<String> blockedStids = blockedStidsExporter.getBlockedStids();
        logger.debug("Blocked stids count: " + blockedStids.size());

        saveBlockedStids(blockedStids);
        logger.debug("Finish extracting blocked stids");
    }

    private void saveBlockedStids(ListF<String> blockedStids) {
        createExportDirIfNotExists();
        File2 tmpFile = exportDir.child("blocked-stids-" + Random2.R.nextAlnum(5) + ".txt");
        tmpFile.writeLines(blockedStids);
        tmpFile.renameTo(exportDir.child(exportStidsFileName));
    }

    private void createExportDirIfNotExists() {
        if (!exportDir.exists()) {
            exportDir.mkdirs();
        }
    }

}
