package ru.yandex.chemodan.app.worker2.export;

import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.bazinga.BazingaControllerApp;
import ru.yandex.commune.bazinga.BazingaWorkerApp;
import ru.yandex.commune.bazinga.impl.worker.BazingaHostPort;
import ru.yandex.misc.io.http.apache.v4.ApacheHttpClientUtils;
import ru.yandex.misc.io.http.apache.v4.ReadStringResponseHandler;
import ru.yandex.misc.lang.StringUtils;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author akirakozov
 */
public class BlockedStidsExporter {
    private static final Logger logger = LoggerFactory.getLogger(BlockedStidsExportWorker.class);

    @Autowired
    private BlockedFileDao blockedFileDao;
    @Autowired
    private BazingaWorkerApp workerApp;
    @Autowired
    private BazingaControllerApp controllerApp;

    private final HttpClient httpClient;

    @Value("${worker.task.http.port}")
    private int blockedStidsHandlePort;

    public BlockedStidsExporter(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public ListF<String> getBlockedStids() {
        if (controllerApp.getBazingaController().isMaster()) {
            logger.debug("Master host, get blocked stids from db");
            return getBlockedStidsFromDb();
        } else {
            Option<BazingaHostPort> masterHostPort = workerApp.getBazingaWorker().getControllerHostPort();
            if (!masterHostPort.isPresent()) {
                logger.debug("Couldn't find master host, get blocked stids from db");
                return blockedFileDao.getAllBlockedStids().map(StringUtils.addPrefixF("/"));
            } else {
                logger.debug("Slave host, get blocked stids from master host");
                return getBlockedStidsFromMaster(masterHostPort.get().getHost());
            }
        }
    }

    private ListF<String> getBlockedStidsFromDb() {
        return blockedFileDao.getAllBlockedStids().map(StringUtils.addPrefixF("/"));
    }

    private ListF<String> getBlockedStidsFromMaster(String host) {
        String url = "http://" + host + ":" + blockedStidsHandlePort + GetBlockedStidsServlet.HANDLE_PATH;
        String result = ApacheHttpClientUtils.execute(new HttpGet(url), httpClient, new ReadStringResponseHandler());
        return Cf.list(StringUtils.split(result, "\n"));
    }
}
