package ru.yandex.chemodan.app.worker2.export;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.ServerAddress;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.commune.mongo.MongoUtils;
import ru.yandex.inside.admin.conductor.Conductor;
import ru.yandex.inside.admin.conductor.GroupOrHost;
import ru.yandex.misc.ip.IpPort;
import ru.yandex.misc.lang.tsb.YandexToStringBuilder;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

@Configuration
public class ExportBlockedFilesConfiguration {
    private static final Logger logger =
            LoggerFactory.getLogger(ExportBlockedFilesConfiguration.class);

    @Bean
    public MongoClient mpfsMongo(
            @Value("${mpfs.mongo.hosts}")
            GroupOrHost hosts,
            @Value("${mpfs.mongo.port}")
            IpPort port,
            @Value("${mpfs.mongo.connections.per.host}")
            int connectionsPerHost,
            @Value("${mpfs.mongo.connect.timeout.ms}")
            int connectTimeoutMs,
            @Value("${mpfs.mongo.socket.timeout.ms}")
            int socketTimeoutMs,
            @Value("${mpfs.mongo.pool.timeout.ms}")
            int poolWaitTimeoutMs,
            Conductor conductor)
    {
        ListF<ServerAddress> hostList = conductor.hostsFromString(hosts).map(MongoUtils.consServerAddressF(port));

        MongoClientOptions mongoOptions = MongoClientOptions.builder()
                .connectionsPerHost(connectionsPerHost)
                .connectTimeout(connectTimeoutMs)
                .socketTimeout(socketTimeoutMs)
                .maxWaitTime(poolWaitTimeoutMs)
                .build();

        logger.info("Starting mongo client to hosts {} with options: {}", hostList,
                YandexToStringBuilder.reflectionToStringValueObject(mongoOptions));

        return new MongoClient(hostList, mongoOptions);
    }

    @Bean
    public BlockedFileDao blockedFileDao(
            @Value("${mpfs.mongo.blocked.file.db.name}")
            String dbName,
            @Value("${mpfs.mongo.support.collection.name}")
            String supportCollectionName,
            @Value("${blocked.stids.export.mongo.batch.size}")
            int batchSize,
            @Qualifier("mpfsMongo")
            MongoClient mongoClient)
    {
        return new BlockedFileDao(mongoClient.getDB(dbName).getCollection(supportCollectionName), batchSize);
    }
}
