package ru.yandex.chemodan.app.worker2.export;

import java.io.IOException;

import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Value;

import ru.yandex.misc.io.OutputStreamOutputStreamSource;
import ru.yandex.misc.io.file.File2;
import ru.yandex.misc.io.http.HttpStatus;

/**
 * @author akirakozov
 */
@SuppressWarnings("serial")
public class GetBlockedStidsServlet extends HttpServlet {

    public static final String HANDLE_PATH = "/blocking";

    @Value("${blocked.stids.export.dir}")
    private File2 exportDir;
    @Value("${blocked.stids.export.file}")
    private String exportStidsFileName;

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        File2 blockedStidsFile = exportDir.child(exportStidsFileName);

        if (blockedStidsFile.exists()) {
            resp.setStatus(HttpStatus.SC_200_OK);
            resp.setContentType("text/plain");
            resp.setContentLength((int) blockedStidsFile.length());
            new OutputStreamOutputStreamSource(resp.getOutputStream()).writeFrom(blockedStidsFile);
        } else {
            resp.setStatus(HttpStatus.SC_404_NOT_FOUND);
        }
    }

}
