<?xml version="1.0"?>
<xsl:stylesheet
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        version="2.0"
        exclude-result-prefixes="#all"
>

    <xsl:import href="admin://common.xsl"/>

    <xsl:template match="page" mode="content">
        <xsl:apply-templates select="content"/>
    </xsl:template>

    <xsl:template match="content">
        <div id="content" class="container">
            <xsl:if test="count(tasks[state='error']) > 0">
                <hr/>
                <h2>Failed tasks</h2>
                <xsl:apply-templates select="tasks[state='error']"/>
            </xsl:if>

            <xsl:if test="count(tasks[state='in-progress']) > 0">
                <hr/>
                <h2>Active tasks</h2>
                <xsl:apply-templates select="tasks[state='in-progress']"/>
            </xsl:if>

            <xsl:if test="count(tasks[state='suspended']) > 0">
                <hr/>
                <h2>Suspended tasks</h2>
                <xsl:apply-templates select="tasks[state='suspended']"/>
            </xsl:if>

            <xsl:if test="count(tasks[state='finished']) > 0">
                <hr/>
                <h2>Finished tasks</h2>
                <xsl:apply-templates select="tasks[state='finished']"/>
            </xsl:if>

            <h3>Create new long task</h3>
            <form class="form-horizontal" action="/z/long-tasks/add" method="post">
                <div class="control-group">
                    <label class="control-label" for="description">Description of task (optional)</label>
                    <div class="controls">
                        <input type="text" name="description" id="description"/>
                    </div>
                </div>
                <div class="control-group">
                    <label class="control-label" for="taskId">Task id</label>
                    <div class="controls">
                        <input type="text" name="taskId" id="taskId" placeholder="taskId..."/>
                    </div>
                </div>
                <div class="control-group">
                    <label class="control-label" for="parametersFilePath">Path to file with parameters list</label>
                    <div class="controls">
                        <input type="text" name="parametersFilePath" id="parametersFilePath" placeholder="/home/..."/>
                    </div>
                </div>
                <div class="control-group">
                    <label class="control-label" for="scheduledThreshold">Bazinga queue</label>
                    <div class="controls">
                        <input type="number" name="scheduledThreshold" id="scheduledThreshold" value="10000"/>
                    </div>
                </div>
                <div class="control-group">
                    <div class="controls">
                        <button type="submit" class="btn btn-primary">Create long task</button>
                    </div>
                </div>
            </form>
        </div>
    </xsl:template>

    <xsl:template match="tasks">
        <xsl:if test="position() != 1">
            <hr/>
        </xsl:if>
        <div>
            <xsl:choose>
                <xsl:when test="state='error'">
                    <xsl:attribute name="class">alert alert-danger</xsl:attribute>
                </xsl:when>
                <xsl:when test="state='in-progress'">
                    <xsl:attribute name="class">alert alert-info</xsl:attribute>
                </xsl:when>
                <xsl:when test="state='suspended'">
                    <xsl:attribute name="class">well</xsl:attribute>
                </xsl:when>
            </xsl:choose>
            <div class="btn-group">
                <a href="long-tasks/remove?taskId={id}" class="btn btn-danger">Remove</a>
                <xsl:choose>
                    <xsl:when test="state='in-progress'">
                        <a href="long-tasks/suspend?taskId={id}" class="btn">Suspend</a>
                    </xsl:when>
                    <xsl:when test="state='suspended' or state='error'">
                        <a href="long-tasks/resume?taskId={id}" class="btn">Resume</a>
                    </xsl:when>
                </xsl:choose>
            </div>
            <br/><br/>

            <xsl:if test="description">
                <h3>
                    <xsl:value-of select="description"/>
                </h3>
            </xsl:if>
            <table class="table-condensed table-bordered" width="100%">
                <tr>
                    <td width="13%">
                        Id
                    </td>
                    <td>
                        <xsl:value-of select="id"/>
                    </td>
                </tr>
                <tr>
                    <td>
                        Bazinga task
                    </td>
                    <td>
                        <xsl:value-of select="task-id"/>
                    </td>
                </tr>
                <tr>
                    <td>
                        Scheduled jobs
                    </td>
                    <td>
                        <xsl:value-of select="scheduled-tasks-count"/>
                        of
                        <xsl:value-of select="total-tasks-count"/>
                        (
                        remaining <xsl:value-of select="remaining-tasks-count"/>
                        )
                    </td>
                </tr>
                <tr>
                    <td>
                        Bazinga queue
                    </td>
                    <td contenteditable="true" onkeydown="changeThreshold(event, '{id}')">
                        <xsl:value-of select="scheduled-threshold"/>
                    </td>
                </tr>
                <xsl:if test="error-message">
                    <tr>
                        <td>
                            Error
                        </td>
                        <td>
                            <xsl:value-of select="error-message"/><br/>
                            <a onclick="$(this).next().slideDown(); return false;" href="#">Stack trace</a>
                            <div if="stack-trace-{id}" style="display:none;">
                                <pre>
                                    <xsl:value-of select="error-stack-trace"/>
                                </pre>
                            </div>
                        </td>
                    </tr>
                </xsl:if>
            </table>
        </div>

        <script type="text/javascript">
            function changeThreshold(event, taskId) {
                if (!event) {
                    event = window.event;
                }
                var keyCode = event.which || event.keyCode;
                var target = event.target || event.srcElement;

                if (keyCode === 13) {
                    event.preventDefault();
                    window.location.href = "long-tasks/threshold?taskId=" + taskId
                            + "&amp;scheduledThreshold=" + parseInt(target.innerHTML, 10);
                }
            }
        </script>

    </xsl:template>

</xsl:stylesheet>
