package ru.yandex.chemodan.app.worker2.queued;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.a3.action.ActionContainer;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.commune.admin.z.EmptyContentPojo;
import ru.yandex.commune.admin.z.ZAction;
import ru.yandex.commune.admin.z.ZRedirectException;
import ru.yandex.commune.bazinga.impl.TaskId;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.XmlRootElement;
import ru.yandex.misc.lang.StringUtils;

/**
 * @author tolmalev
 */
@ActionContainer
public class LongTasksAdminPage {
    private final LongTasksManager longTasksManager;

    public LongTasksAdminPage(LongTasksManager longTasksManager) {
        this.longTasksManager = longTasksManager;
    }

    @ZAction(defaultAction = true)
    @Path("/long-tasks")
    public ListLongTasksPojo index() {
        return new ListLongTasksPojo(longTasksManager.listTasks());
    }

    @Path(value = "/long-tasks/add", methods = HttpMethod.POST)
    public EmptyContentPojo addNewTask(
            @RequestParam("taskId")
            String taskId,
            @RequestParam("parametersFilePath")
            String filePath,
            @RequestParam("description")
            String description,
            @RequestParam("scheduledThreshold")
            int scheduledThreshold)
    {
        longTasksManager.createLongTask(new TaskId(taskId), filePath, scheduledThreshold,
                Option.ofNullable(StringUtils.trimToNull(description)));
        throw new ZRedirectException("/z/long-tasks");
    }

    @Path(value = "/long-tasks/suspend")
    public EmptyContentPojo suspendTask(
            @RequestParam("taskId")
            String longTaskId)
    {
        longTasksManager.suspendLongTask(longTaskId);
        throw new ZRedirectException("/z/long-tasks");
    }

    @Path(value = "/long-tasks/resume")
    public EmptyContentPojo resumeTask(
            @RequestParam("taskId")
            String longTaskId)
    {
        longTasksManager.resumeLongTask(longTaskId);
        throw new ZRedirectException("/z/long-tasks");
    }

    @Path(value = "/long-tasks/remove")
    public EmptyContentPojo removeTask(
            @RequestParam("taskId")
            String longTaskId)
    {
        longTasksManager.removeTask(longTaskId);
        throw new ZRedirectException("/z/long-tasks");
    }

    @Path(value = "/long-tasks/threshold")
    public EmptyContentPojo changeScheduledThreshold(
            @RequestParam("taskId")
            String longTaskId,
            @RequestParam("scheduledThreshold")
            int newScheduledThreshold)
    {
        longTasksManager.changeScheduledThreshold(longTaskId, newScheduledThreshold);
        throw new ZRedirectException("/z/long-tasks");
    }

    @BenderBindAllFields
    @XmlRootElement(name = "content")
    public final static class ListLongTasksPojo {
        public final ListF<LongTask> tasks;

        public ListLongTasksPojo(ListF<LongTask> tasks) {
            this.tasks = tasks;
        }
    }
}
